import QtQuick
import QtQuick.Controls

Rectangle {
    id: skeuoDesignStudies
    width: 486
    height: 518
    color: "transparent"

    Rectangle {
        id: background
        radius: 30
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        gradient: Gradient {
            id: background_Gradient
            GradientStop {
                id: background_GradientStop_0
                position: 1
                color: "#ffafafaf"
            }

            GradientStop {
                id: background_GradientStop_1
                position: 0
                color: "#ff9b9b9b"
            }
            orientation: Gradient.Horizontal
        }
    }

    SkeuoDial {
        id: skeuoDial
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.leftMargin: 202
        anchors.rightMargin: 34
        anchors.topMargin: 81
        anchors.bottomMargin: 187
    }

    DualIndicator {
        id: dualIndicator
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.leftMargin: 157
        anchors.rightMargin: 179
        anchors.topMargin: 402
        anchors.bottomMargin: 40
    }

    PressSwitch {
        id: clickSwitch
        anchors.left: parent.left
        anchors.right: parent.right
        anchors.top: parent.top
        anchors.bottom: parent.bottom
        anchors.leftMargin: 54
        anchors.rightMargin: 343
        anchors.topMargin: 110
        anchors.bottomMargin: 258
    }
}

/*##^##
Designer {
    D{i:0;uuid:"304e46d2-b9cf-517f-af94-28fd647c30a6"}D{i:1;uuid:"fe784a1a-a8d4-5e6a-94f4-b04f00d4e730"}
D{i:2;uuid:"fe784a1a-a8d4-5e6a-94f4-b04f00d4e730_Gradient"}D{i:3;uuid:"fe784a1a-a8d4-5e6a-94f4-b04f00d4e730_GradientStop_0"}
D{i:4;uuid:"fe784a1a-a8d4-5e6a-94f4-b04f00d4e730_GradientStop_1"}D{i:5;uuid:"faf18303-bc99-5b07-a7ce-2d4c542c2ac7"}
D{i:6;uuid:"f7637326-470e-54cf-8c52-abd445bca5cb"}D{i:7;uuid:"2c0f163f-7bd6-58de-88f6-90faac8e7014"}
}
##^##*/

